//
//  GHCustomFITSettings.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 8/29/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import "GHCustomSettings.h"

/**
 *  The GHCustomFITSettings class contains FIT widget settings values retrieved
 *  from a Garmin device or is used to to set new values on on the device.
 */
@interface GHCustomFITSettings : GHCustomSettings

/**
 * The number of steps to be completed for the Frequency metric.
 */
@property (nonnull, nonatomic) NSNumber *frequencyStepGoal;

/**
 * The duration in minutes for a segment of the Frequency metric.
 */
@property (nonnull, nonatomic) NSNumber *frequencyDuration;

/**
 * The interval in minutes between segments of the Frequency metric.
 */
@property (nonnull, nonatomic) NSNumber *frequencyInterval;

/**
 * The number of segments for the Frequency metric.
 */
@property (nonnull, nonatomic) NSNumber *frequencySegments;

/**
 * The number of steps to be completed for the Intensity metric.
 */
@property (nonnull, nonatomic) NSNumber *intensityStepGoal;

/**
 * The duration in minutes for a segment of the Intensity metric.
 */
@property (nonnull, nonatomic) NSNumber *intensityDuration;

/**
 * The number of steps to be completed for the Tenacity metric.
 */
@property (nonnull, nonatomic) NSNumber *tenacityStepGoal;


@end
